<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * TodoListsVTodoQuery.
 */
class TodoListsVTodoQuery  {

  /*
   * @type String
   */
  public $owner;

  /*
   * @type List
   */
  public $containers;

  /*
   * @type VTodoQuery
   */
  public $vtodoQuery;

  /*
   * Constructor
   */
  public function __construct() {
    $this->owner = "";
    $this->containers =  array();
    $this->vtodoQuery =   new VTodoQuery();
  }

  public function toMap() {
    $data = array(    
        "owner" => empty($this->owner) ? null : $this->owner,    
        "containers" => empty($this->containers) ? null : $this->containers,    
        "vtodoQuery" => empty($this->vtodoQuery) ? null : $this->vtodoQuery);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
