/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardOrganizationalMemberGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Organizational.Member> {

	public VCardOrganizationalMemberGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Organizational.Member deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Organizational.Member ret = new net.bluemind.addressbook.api.VCard.Organizational.Member();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Organizational.Member ret, JSONObject json) {

		JSONValue commonNameJSON = json.get("commonName");
		ret.commonName =  GwtSerDerUtils.STRING.deserialize(commonNameJSON);
		JSONValue mailtoJSON = json.get("mailto");
		ret.mailto =  GwtSerDerUtils.STRING.deserialize(mailtoJSON);
		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue itemUidJSON = json.get("itemUid");
		ret.itemUid =  GwtSerDerUtils.STRING.deserialize(itemUidJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Organizational.Member o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Organizational.Member o, JSONObject ret) {

		ret.put("commonName",  GwtSerDerUtils.STRING.serialize( o.commonName ));
		ret.put("mailto",  GwtSerDerUtils.STRING.serialize( o.mailto ));
		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("itemUid",  GwtSerDerUtils.STRING.serialize( o.itemUid ));
	}
}