/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardIdentificationNameGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Identification.Name> {

    private net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer parent = new  net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer(); 
	public VCardIdentificationNameGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Identification.Name deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Identification.Name ret = new net.bluemind.addressbook.api.VCard.Identification.Name();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Identification.Name ret, JSONObject json) {
		parent.deserializeTo( ret, json);

		JSONValue familyNamesJSON = json.get("familyNames");
		ret.familyNames =  GwtSerDerUtils.STRING.deserialize(familyNamesJSON);
		JSONValue givenNamesJSON = json.get("givenNames");
		ret.givenNames =  GwtSerDerUtils.STRING.deserialize(givenNamesJSON);
		JSONValue additionalNamesJSON = json.get("additionalNames");
		ret.additionalNames =  GwtSerDerUtils.STRING.deserialize(additionalNamesJSON);
		JSONValue prefixesJSON = json.get("prefixes");
		ret.prefixes =  GwtSerDerUtils.STRING.deserialize(prefixesJSON);
		JSONValue suffixesJSON = json.get("suffixes");
		ret.suffixes =  GwtSerDerUtils.STRING.deserialize(suffixesJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Identification.Name o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Identification.Name o, JSONObject ret) {
		parent.serializeTo( o, ret);

		ret.put("familyNames",  GwtSerDerUtils.STRING.serialize( o.familyNames ));
		ret.put("givenNames",  GwtSerDerUtils.STRING.serialize( o.givenNames ));
		ret.put("additionalNames",  GwtSerDerUtils.STRING.serialize( o.additionalNames ));
		ret.put("prefixes",  GwtSerDerUtils.STRING.serialize( o.prefixes ));
		ret.put("suffixes",  GwtSerDerUtils.STRING.serialize( o.suffixes ));
	}
}