/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class OrgUnitPathGwtSerDer implements GwtSerDer<net.bluemind.directory.api.OrgUnitPath> {

	public OrgUnitPathGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.OrgUnitPath deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.OrgUnitPath ret = new net.bluemind.directory.api.OrgUnitPath();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.OrgUnitPath ret, JSONObject json) {

		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue parentJSON = json.get("parent");
		ret.parent =  new net.bluemind.directory.api.gwt.serder.OrgUnitPathGwtSerDer().deserialize(parentJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.directory.api.OrgUnitPath o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.OrgUnitPath o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("parent",  new net.bluemind.directory.api.gwt.serder.OrgUnitPathGwtSerDer().serialize( o.parent ));
	}
}