/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class BaseDirEntryGwtSerDer implements GwtSerDer<net.bluemind.directory.api.BaseDirEntry> {

	public BaseDirEntryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.BaseDirEntry deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.BaseDirEntry ret = new net.bluemind.directory.api.BaseDirEntry();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.BaseDirEntry ret, JSONObject json) {

		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue entryUidJSON = json.get("entryUid");
		ret.entryUid =  GwtSerDerUtils.STRING.deserialize(entryUidJSON);
		JSONValue accountTypeJSON = json.get("accountType");
		ret.accountType =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().deserialize(accountTypeJSON);
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().deserialize(kindJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.directory.api.BaseDirEntry o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.BaseDirEntry o, JSONObject ret) {

		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("entryUid",  GwtSerDerUtils.STRING.serialize( o.entryUid ));
		ret.put("accountType",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().serialize( o.accountType ));
		ret.put("kind",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().serialize( o.kind ));
	}
}