/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class DirectoryEndpointPromise implements net.bluemind.directory.api.IDirectoryPromise {

	private net.bluemind.directory.api.IDirectoryAsync impl;

	public DirectoryEndpointPromise(net.bluemind.directory.api.IDirectoryAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<byte[]> getEntryIcon(String entryUid  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getEntryIcon(entryUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> getVCard(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVCard(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> delete(String path  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> getByRoles(List<String> roles  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getByRoles(roles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> search(net.bluemind.directory.api.DirEntryQuery query  ) {
		
		CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>();
		AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>() {
			public void success(net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.search(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.directory.api.DirEntry> findByEntryUid(String entryUid  ) {
		
		CompletableFuture<net.bluemind.directory.api.DirEntry> ret = new CompletableFuture<net.bluemind.directory.api.DirEntry>();
		AsyncHandler<net.bluemind.directory.api.DirEntry> handler = new AsyncHandler<net.bluemind.directory.api.DirEntry>() {
			public void success(net.bluemind.directory.api.DirEntry value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.findByEntryUid(entryUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> getMultiple(List<String> id  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMultiple(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> getEntryPhoto(String entryUid  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getEntryPhoto(entryUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.directory.api.DirEntry> getEntry(String path  ) {
		
		CompletableFuture<net.bluemind.directory.api.DirEntry> ret = new CompletableFuture<net.bluemind.directory.api.DirEntry>();
		AsyncHandler<net.bluemind.directory.api.DirEntry> handler = new AsyncHandler<net.bluemind.directory.api.DirEntry>() {
			public void success(net.bluemind.directory.api.DirEntry value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getEntry(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.directory.api.DirEntry> getRoot() {
		
		CompletableFuture<net.bluemind.directory.api.DirEntry> ret = new CompletableFuture<net.bluemind.directory.api.DirEntry>();
		AsyncHandler<net.bluemind.directory.api.DirEntry> handler = new AsyncHandler<net.bluemind.directory.api.DirEntry>() {
			public void success(net.bluemind.directory.api.DirEntry value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRoot( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> deleteByEntryUid(String entryUid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteByEntryUid(entryUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> xfer(String entryUid ,  String serverUid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.xfer(entryUid, serverUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.directory.api.DirEntry> getByEmail(String email  ) {
		
		CompletableFuture<net.bluemind.directory.api.DirEntry> ret = new CompletableFuture<net.bluemind.directory.api.DirEntry>();
		AsyncHandler<net.bluemind.directory.api.DirEntry> handler = new AsyncHandler<net.bluemind.directory.api.DirEntry>() {
			public void success(net.bluemind.directory.api.DirEntry value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getByEmail(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getRolesForDirEntry(String entryUid  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRolesForDirEntry(entryUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> changelog(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangelog>() {
			public void success(net.bluemind.core.container.model.ContainerChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changelog(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getRolesForOrgUnit(String ouUid  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRolesForOrgUnit(ouUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> getIcon(String path  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getIcon(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.directory.api.DirEntry>> getEntries(String path  ) {
		
		CompletableFuture<List<net.bluemind.directory.api.DirEntry>> ret = new CompletableFuture<List<net.bluemind.directory.api.DirEntry>>();
		AsyncHandler<List<net.bluemind.directory.api.DirEntry>> handler = new AsyncHandler<List<net.bluemind.directory.api.DirEntry>>() {
			public void success(List<net.bluemind.directory.api.DirEntry> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getEntries(path,  handler);
		return ret;
	}

}
