/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VTodoGwtSerDer implements GwtSerDer<net.bluemind.todolist.api.VTodo> {

    private net.bluemind.icalendar.api.gwt.serder.ICalendarElementGwtSerDer parent = new  net.bluemind.icalendar.api.gwt.serder.ICalendarElementGwtSerDer(); 
	public VTodoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.todolist.api.VTodo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.todolist.api.VTodo ret = new net.bluemind.todolist.api.VTodo();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.todolist.api.VTodo ret, JSONObject json) {
		parent.deserializeTo( ret, json);

		JSONValue dueJSON = json.get("due");
		ret.due =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dueJSON);
		JSONValue percentJSON = json.get("percent");
		ret.percent =  GwtSerDerUtils.INT.deserialize(percentJSON);
		JSONValue completedJSON = json.get("completed");
		ret.completed =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(completedJSON);
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.todolist.api.VTodo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.todolist.api.VTodo o, JSONObject ret) {
		parent.serializeTo( o, ret);

		ret.put("due",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.due ));
		ret.put("percent",  GwtSerDerUtils.INT.serialize( o.percent ));
		ret.put("completed",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.completed ));
		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
	}
}