/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class TodoListsEndpointPromise implements net.bluemind.todolist.api.ITodoListsPromise {

	private net.bluemind.todolist.api.ITodoListsAsync impl;

	public TodoListsEndpointPromise(net.bluemind.todolist.api.ITodoListsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>>> search(net.bluemind.todolist.api.TodoListsVTodoQuery query  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>>>() {
			public void success(List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.search(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.core.container.model.ContainerDescriptor descriptor  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, descriptor,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}

}
