<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCard.
 */
class VCard  {

  /*
   * @type VCardKind
   */
  public $kind;

  /*
   * @type String
   */
  public $source;

  /*
   * @type VCardIdentification
   */
  public $identification;

  /*
   * @type List
   */
  public $deliveryAddressing;

  /*
   * @type VCardCommunications
   */
  public $communications;

  /*
   * @type VCardOrganizational
   */
  public $organizational;

  /*
   * @type VCardExplanatory
   */
  public $explanatory;

  /*
   * @type VCardSecurity
   */
  public $security;

  /*
   * @type VCardRelated
   */
  public $related;

  /*
   * Constructor
   */
  public function __construct() {
    $this->source = "";
    $this->identification =   new VCardIdentification();
    $this->deliveryAddressing =  array();
    $this->communications =   new VCardCommunications();
    $this->organizational =   new VCardOrganizational();
    $this->explanatory =   new VCardExplanatory();
    $this->security =   new VCardSecurity();
    $this->related =   new VCardRelated();
  }

  public function toMap() {
    $data = array(    
        "kind" => empty($this->kind) ? null : $this->kind,    
        "source" => empty($this->source) ? null : $this->source,    
        "identification" => empty($this->identification) ? null : $this->identification,    
        "deliveryAddressing" => empty($this->deliveryAddressing) ? null : $this->deliveryAddressing,    
        "communications" => empty($this->communications) ? null : $this->communications,    
        "organizational" => empty($this->organizational) ? null : $this->organizational,    
        "explanatory" => empty($this->explanatory) ? null : $this->explanatory,    
        "security" => empty($this->security) ? null : $this->security,    
        "related" => empty($this->related) ? null : $this->related);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
