/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SearchQuerySearchScopeGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.SearchQuery.SearchScope> {

	public SearchQuerySearchScopeGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.SearchQuery.SearchScope deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.SearchQuery.SearchScope ret = new net.bluemind.backend.mail.api.SearchQuery.SearchScope();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchQuery.SearchScope ret, JSONObject json) {

		JSONValue folderScopeJSON = json.get("folderScope");
		ret.folderScope =  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryFolderScopeGwtSerDer().deserialize(folderScopeJSON);
		JSONValue isDeepTraversalJSON = json.get("isDeepTraversal");
		ret.isDeepTraversal =  GwtSerDerUtils.BOOLEAN.deserialize(isDeepTraversalJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.SearchQuery.SearchScope o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchQuery.SearchScope o, JSONObject ret) {

		ret.put("folderScope",  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryFolderScopeGwtSerDer().serialize( o.folderScope ));
		ret.put("isDeepTraversal",  GwtSerDerUtils.BOOLEAN.serialize( o.isDeepTraversal ));
	}
}