/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageBodyGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageBody> {

	public MessageBodyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageBody deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageBody ret = new net.bluemind.backend.mail.api.MessageBody();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody ret, JSONObject json) {

		JSONValue guidJSON = json.get("guid");
		ret.guid =  GwtSerDerUtils.STRING.deserialize(guidJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue smartAttachJSON = json.get("smartAttach");
		ret.smartAttach =  GwtSerDerUtils.BOOLEAN.deserialize(smartAttachJSON);
		JSONValue dateJSON = json.get("date");
		ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue headersJSON = json.get("headers");
		ret.headers =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).deserialize(headersJSON);
		JSONValue recipientsJSON = json.get("recipients");
		ret.recipients =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientGwtSerDer()).deserialize(recipientsJSON);
		JSONValue messageIdJSON = json.get("messageId");
		ret.messageId =  GwtSerDerUtils.STRING.deserialize(messageIdJSON);
		JSONValue referencesJSON = json.get("references");
		ret.references =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(referencesJSON);
		JSONValue structureJSON = json.get("structure");
		ret.structure =  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer().deserialize(structureJSON);
		JSONValue previewJSON = json.get("preview");
		ret.preview =  GwtSerDerUtils.STRING.deserialize(previewJSON);
		JSONValue bodyVersionJSON = json.get("bodyVersion");
		ret.bodyVersion =  GwtSerDerUtils.INT.deserialize(bodyVersionJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageBody o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody o, JSONObject ret) {

		ret.put("guid",  GwtSerDerUtils.STRING.serialize( o.guid ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("smartAttach",  GwtSerDerUtils.BOOLEAN.serialize( o.smartAttach ));
		ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("headers",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).serialize( o.headers ));
		ret.put("recipients",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientGwtSerDer()).serialize( o.recipients ));
		ret.put("messageId",  GwtSerDerUtils.STRING.serialize( o.messageId ));
		ret.put("references",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.references ));
		ret.put("structure",  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer().serialize( o.structure ));
		ret.put("preview",  GwtSerDerUtils.STRING.serialize( o.preview ));
		ret.put("bodyVersion",  GwtSerDerUtils.INT.serialize( o.bodyVersion ));
	}
}