/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailboxFolderSearchQueryGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MailboxFolderSearchQuery> {

	public MailboxFolderSearchQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MailboxFolderSearchQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MailboxFolderSearchQuery ret = new net.bluemind.backend.mail.api.MailboxFolderSearchQuery();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MailboxFolderSearchQuery ret, JSONObject json) {

		JSONValue queryJSON = json.get("query");
		ret.query =  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryGwtSerDer().deserialize(queryJSON);
		JSONValue sortJSON = json.get("sort");
		ret.sort =  new net.bluemind.backend.mail.api.gwt.serder.SearchSortGwtSerDer().deserialize(sortJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MailboxFolderSearchQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MailboxFolderSearchQuery o, JSONObject ret) {

		ret.put("query",  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryGwtSerDer().serialize( o.query ));
		ret.put("sort",  new net.bluemind.backend.mail.api.gwt.serder.SearchSortGwtSerDer().serialize( o.sort ));
	}
}