/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ImportMailboxItemsStatusGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> {

	public ImportMailboxItemsStatusGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.ImportMailboxItemsStatus deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.ImportMailboxItemsStatus ret = new net.bluemind.backend.mail.api.ImportMailboxItemsStatus();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.ImportMailboxItemsStatus ret, JSONObject json) {

		JSONValue doneIdsJSON = json.get("doneIds");
		ret.doneIds =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemsStatusImportedMailboxItemGwtSerDer()).deserialize(doneIdsJSON);
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemsStatusImportStatusGwtSerDer().deserialize(statusJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.ImportMailboxItemsStatus o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.ImportMailboxItemsStatus o, JSONObject ret) {

		ret.put("doneIds",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemsStatusImportedMailboxItemGwtSerDer()).serialize( o.doneIds ));
		ret.put("status",  new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemsStatusImportStatusGwtSerDer().serialize( o.status ));
	}
}