/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailboxFoldersEndpointPromise implements net.bluemind.backend.mail.api.IMailboxFoldersPromise {

	private net.bluemind.backend.mail.api.IMailboxFoldersAsync impl;

	public MailboxFoldersEndpointPromise(net.bluemind.backend.mail.api.IMailboxFoldersAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Long> getVersion() {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(Long since ,  net.bluemind.core.container.model.ItemFlagFilter arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.filteredChangesetById(since, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(String uid ,  Long arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ItemChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ItemChangelog>() {
			public void success(net.bluemind.core.container.model.ItemChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.itemChangelog(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> changesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> containerChangelog(Long arg0  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangelog>() {
			public void success(net.bluemind.core.container.model.ContainerChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.containerChangelog(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<Long>> allIds(String filter ,  Long knownContainerVersion ,  Integer limit ,  Integer offset  ) {
		
		CompletableFuture<net.bluemind.core.api.ListResult<Long>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<Long>>();
		AsyncHandler<net.bluemind.core.api.ListResult<Long>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<Long>>() {
			public void success(net.bluemind.core.api.ListResult<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allIds(filter, knownContainerVersion, limit, offset,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> all() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.all( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> byName(String name  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byName(name,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> root() {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.root( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.backend.mail.api.SearchResult> searchItems(net.bluemind.backend.mail.api.MailboxFolderSearchQuery query  ) {
		
		CompletableFuture<net.bluemind.backend.mail.api.SearchResult> ret = new CompletableFuture<net.bluemind.backend.mail.api.SearchResult>();
		AsyncHandler<net.bluemind.backend.mail.api.SearchResult> handler = new AsyncHandler<net.bluemind.backend.mail.api.SearchResult>() {
			public void success(net.bluemind.backend.mail.api.SearchResult value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.searchItems(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> multipleGetById(List<Long> arg0  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGetById(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getCompleteById(long id  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCompleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> importItems(long folderDestinationId ,  net.bluemind.backend.mail.api.ImportMailboxItemSet mailboxItems  ) {
		
		CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> ret = new CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>();
		AsyncHandler<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> handler = new AsyncHandler<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>() {
			public void success(net.bluemind.backend.mail.api.ImportMailboxItemsStatus value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.importItems(folderDestinationId, mailboxItems,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> emptyFolder(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.emptyFolder(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> removeMessages(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.removeMessages(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> markFolderAsRead(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.markFolderAsRead(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> createBasic(net.bluemind.backend.mail.api.MailboxFolder value  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> ret = new CompletableFuture<net.bluemind.core.container.model.ItemIdentifier>();
		AsyncHandler<net.bluemind.core.container.model.ItemIdentifier> handler = new AsyncHandler<net.bluemind.core.container.model.ItemIdentifier>() {
			public void success(net.bluemind.core.container.model.ItemIdentifier value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.createBasic(value,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> createForHierarchy(long hierarchyId ,  net.bluemind.backend.mail.api.MailboxFolder value  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> ret = new CompletableFuture<net.bluemind.core.container.model.ItemIdentifier>();
		AsyncHandler<net.bluemind.core.container.model.ItemIdentifier> handler = new AsyncHandler<net.bluemind.core.container.model.ItemIdentifier>() {
			public void success(net.bluemind.core.container.model.ItemIdentifier value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.createForHierarchy(hierarchyId, value,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id ,  net.bluemind.backend.mail.api.MailboxFolder value  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateById(id, value,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteById(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deepDelete(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deepDelete(id,  handler);
		return ret;
	}

}
