/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailConversationEndpointPromise implements net.bluemind.backend.mail.api.IMailConversationPromise {

	private net.bluemind.backend.mail.api.IMailConversationAsync impl;

	public MailConversationEndpointPromise(net.bluemind.backend.mail.api.IMailConversationAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<String>> byFolder(String folder ,  net.bluemind.core.container.model.ItemFlagFilter filter  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byFolder(folder, filter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>>> multipleGet(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> removeMessage(String containerUid ,  Long itemId  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.removeMessage(containerUid, itemId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.Conversation> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}

}
