/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class MailConversationActionsGwtEndpoint implements net.bluemind.backend.mail.api.IMailConversationActionsAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public MailConversationActionsGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mail_conversation/{conversationContainer}/{replicatedMailboxUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{conversationContainer}",pathVars[0]);
				uri_ = uri_.replace("{replicatedMailboxUid}",pathVars[1]);
		
		baseUri = uri_;
	}

	public MailConversationActionsGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void importItems(long folderDestinationId, net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet mailboxItems, final AsyncHandler<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> handler) {
		String postUri = "/importItems/{folderDestinationId}";

		postUri = postUri.replace("{folderDestinationId}", ""+folderDestinationId);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.ImportMailboxConversationSetGwtSerDer().serialize( mailboxItems);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>(handler) {
			@Override
			protected net.bluemind.backend.mail.api.ImportMailboxItemsStatus handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemsStatusGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void move(String targetMailboxUid, List<String> conversationUids, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/move/{targetMailboxUid}";

		postUri = postUri.replace("{targetMailboxUid}", ""+targetMailboxUid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( conversationUids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void addFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/_addFlag";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.ConversationFlagUpdateGwtSerDer().serialize( flagUpdate);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.Ack>(handler) {
			@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleDeleteById(List<String> conversationUids, final AsyncHandler<Void> handler) {
		String postUri = "/_multipleDelete";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( conversationUids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void deleteFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/_deleteFlag";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.ConversationFlagUpdateGwtSerDer().serialize( flagUpdate);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.Ack>(handler) {
			@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void copy(String targetMailboxUid, List<String> conversationUids, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/copy/{targetMailboxUid}";

		postUri = postUri.replace("{targetMailboxUid}", ""+targetMailboxUid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( conversationUids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.backend.mail.api.IMailConversationActionsPromise promiseApi() {
		return new MailConversationActionsEndpointPromise(this);
	}
}
