/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class ItemsTransferSockJsEndpoint implements net.bluemind.backend.mail.api.IItemsTransferAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public ItemsTransferSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mail_items_transfer/{fromMailboxUid}/{toMailboxUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{fromMailboxUid}",pathVars[0]);
				uri_ = uri_.replace("{toMailboxUid}",pathVars[1]);
		
		baseUri = uri_;
	}

	public ItemsTransferSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void move(List<Long> itemIds, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/move";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( itemIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void copy(List<Long> itemIds, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/copy";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( itemIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.backend.mail.api.IItemsTransferPromise promiseApi() {
		return new ItemsTransferEndpointPromise(this);
	}

}
