/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.flags.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailboxItemFlagGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.flags.MailboxItemFlag> {

	public MailboxItemFlagGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.flags.MailboxItemFlag deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.flags.MailboxItemFlag ret = new net.bluemind.backend.mail.api.flags.MailboxItemFlag();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.flags.MailboxItemFlag ret, JSONObject json) {

		JSONValue flagJSON = json.get("flag");
		ret.flag =  GwtSerDerUtils.STRING.deserialize(flagJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  GwtSerDerUtils.INT.deserialize(valueJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.flags.MailboxItemFlag o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.flags.MailboxItemFlag o, JSONObject ret) {

		ret.put("flag",  GwtSerDerUtils.STRING.serialize( o.flag ));
		ret.put("value",  GwtSerDerUtils.INT.serialize( o.value ));
	}
}