<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ContainerSyncResult.
 */
class ContainerSyncResult  {

  /*
   * @type ContainerSyncStatus
   */
  public $status;

  /*
   * @type int
   */
  public $added;

  /*
   * @type int
   */
  public $updated;

  /*
   * @type int
   */
  public $removed;

  /*
   * @type int
   */
  public $unhandled;

  /*
   * Constructor
   */
  public function __construct() {
    $this->status =   new ContainerSyncStatus();
    $this->added = 0;
    $this->updated = 0;
    $this->removed = 0;
    $this->unhandled = 0;
  }

  public function toMap() {
    $data = array(    
        "status" => empty($this->status) ? null : $this->status,    
        "added" => empty($this->added) ? null : $this->added,    
        "updated" => empty($this->updated) ? null : $this->updated,    
        "removed" => empty($this->removed) ? null : $this->removed,    
        "unhandled" => empty($this->unhandled) ? null : $this->unhandled);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
