<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * BaseContainerDescriptor.
 */
class BaseContainerDescriptor  {

  /*
   * @type String
   */
  public $uid;

  /*
   * @type String
   */
  public $name;

  /*
   * @type String
   */
  public $owner;

  /*
   * @type String
   */
  public $type;

  /*
   * @type boolean
   */
  public $defaultContainer;

  /*
   * @type boolean
   */
  public $readOnly;

  /*
   * @type String
   */
  public $domainUid;

  /*
   * @type String
   */
  public $ownerDisplayname;

  /*
   * @type String
   */
  public $ownerDirEntryPath;

  /*
   * @type Map
   */
  public $settings;

  /*
   * @type boolean
   */
  public $deleted;

  /*
   * @type String
   */
  public $datalocation;

  /*
   * @type long
   */
  public $internalId;

  /*
   * Constructor
   */
  public function __construct() {
    $this->uid = "";
    $this->name = "";
    $this->owner = "";
    $this->type = "";
    $this->defaultContainer = false;
    $this->readOnly = false;
    $this->domainUid = "";
    $this->ownerDisplayname = "";
    $this->ownerDirEntryPath = "";
    $this->settings = array();
    $this->deleted = false;
    $this->datalocation = "";
    $this->internalId = 0;
  }

  public function toMap() {
    $data = array(    
        "uid" => empty($this->uid) ? null : $this->uid,    
        "name" => empty($this->name) ? null : $this->name,    
        "owner" => empty($this->owner) ? null : $this->owner,    
        "type" => empty($this->type) ? null : $this->type,    
        "defaultContainer" => empty($this->defaultContainer) ? null : $this->defaultContainer,    
        "readOnly" => empty($this->readOnly) ? null : $this->readOnly,    
        "domainUid" => empty($this->domainUid) ? null : $this->domainUid,    
        "ownerDisplayname" => empty($this->ownerDisplayname) ? null : $this->ownerDisplayname,    
        "ownerDirEntryPath" => empty($this->ownerDirEntryPath) ? null : $this->ownerDirEntryPath,    
        "settings" => empty($this->settings) ? null : $this->settings,    
        "deleted" => empty($this->deleted) ? null : $this->deleted,    
        "datalocation" => empty($this->datalocation) ? null : $this->datalocation,    
        "internalId" => empty($this->internalId) ? null : $this->internalId);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
