/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.icalendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ICalendarElementAttendeeGwtSerDer implements GwtSerDer<net.bluemind.icalendar.api.ICalendarElement.Attendee> {

	public ICalendarElementAttendeeGwtSerDer( ) {
	}

	@Override
	public net.bluemind.icalendar.api.ICalendarElement.Attendee deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.icalendar.api.ICalendarElement.Attendee ret = new net.bluemind.icalendar.api.ICalendarElement.Attendee();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.Attendee ret, JSONObject json) {

		JSONValue cutypeJSON = json.get("cutype");
		ret.cutype =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementCUTypeGwtSerDer().deserialize(cutypeJSON);
		JSONValue memberJSON = json.get("member");
		ret.member =  GwtSerDerUtils.STRING.deserialize(memberJSON);
		JSONValue roleJSON = json.get("role");
		ret.role =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRoleGwtSerDer().deserialize(roleJSON);
		JSONValue partStatusJSON = json.get("partStatus");
		ret.partStatus =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementParticipationStatusGwtSerDer().deserialize(partStatusJSON);
		JSONValue rsvpJSON = json.get("rsvp");
		ret.rsvp =  GwtSerDerUtils.BOOLEAN.deserialize(rsvpJSON);
		JSONValue delToJSON = json.get("delTo");
		ret.delTo =  GwtSerDerUtils.STRING.deserialize(delToJSON);
		JSONValue delFromJSON = json.get("delFrom");
		ret.delFrom =  GwtSerDerUtils.STRING.deserialize(delFromJSON);
		JSONValue sentByJSON = json.get("sentBy");
		ret.sentBy =  GwtSerDerUtils.STRING.deserialize(sentByJSON);
		JSONValue commonNameJSON = json.get("commonName");
		ret.commonName =  GwtSerDerUtils.STRING.deserialize(commonNameJSON);
		JSONValue dirJSON = json.get("dir");
		ret.dir =  GwtSerDerUtils.STRING.deserialize(dirJSON);
		JSONValue langJSON = json.get("lang");
		ret.lang =  GwtSerDerUtils.STRING.deserialize(langJSON);
		JSONValue mailtoJSON = json.get("mailto");
		ret.mailto =  GwtSerDerUtils.STRING.deserialize(mailtoJSON);
		JSONValue uriJSON = json.get("uri");
		ret.uri =  GwtSerDerUtils.STRING.deserialize(uriJSON);
		JSONValue internalJSON = json.get("internal");
		ret.internal =  GwtSerDerUtils.BOOLEAN.deserialize(internalJSON);
		JSONValue responseCommentJSON = json.get("responseComment");
		ret.responseComment =  GwtSerDerUtils.STRING.deserialize(responseCommentJSON);
		JSONValue counterJSON = json.get("counter");
		ret.counter =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(counterJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.icalendar.api.ICalendarElement.Attendee o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.Attendee o, JSONObject ret) {

		ret.put("cutype",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementCUTypeGwtSerDer().serialize( o.cutype ));
		ret.put("member",  GwtSerDerUtils.STRING.serialize( o.member ));
		ret.put("role",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRoleGwtSerDer().serialize( o.role ));
		ret.put("partStatus",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementParticipationStatusGwtSerDer().serialize( o.partStatus ));
		ret.put("rsvp",  GwtSerDerUtils.BOOLEAN.serialize( o.rsvp ));
		ret.put("delTo",  GwtSerDerUtils.STRING.serialize( o.delTo ));
		ret.put("delFrom",  GwtSerDerUtils.STRING.serialize( o.delFrom ));
		ret.put("sentBy",  GwtSerDerUtils.STRING.serialize( o.sentBy ));
		ret.put("commonName",  GwtSerDerUtils.STRING.serialize( o.commonName ));
		ret.put("dir",  GwtSerDerUtils.STRING.serialize( o.dir ));
		ret.put("lang",  GwtSerDerUtils.STRING.serialize( o.lang ));
		ret.put("mailto",  GwtSerDerUtils.STRING.serialize( o.mailto ));
		ret.put("uri",  GwtSerDerUtils.STRING.serialize( o.uri ));
		ret.put("internal",  GwtSerDerUtils.BOOLEAN.serialize( o.internal ));
		ret.put("responseComment",  GwtSerDerUtils.STRING.serialize( o.responseComment ));
		ret.put("counter",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.counter ));
	}
}