/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementRole extends JavaScriptObject {

	protected JsICalendarElementRole() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsICalendarElementRole Chair()
	/*-{
		return "Chair";
	}-*/;

	public static final native JsICalendarElementRole RequiredParticipant()
	/*-{
		return "RequiredParticipant";
	}-*/;

	public static final native JsICalendarElementRole OptionalParticipant()
	/*-{
		return "OptionalParticipant";
	}-*/;

	public static final native JsICalendarElementRole NonParticipant()
	/*-{
		return "NonParticipant";
	}-*/;

	public static final JsICalendarElementRole create(net.bluemind.icalendar.api.ICalendarElement.Role value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Chair:
				return Chair();
			case RequiredParticipant:
				return RequiredParticipant();
			case OptionalParticipant:
				return OptionalParticipant();
			case NonParticipant:
				return NonParticipant();
			default:
				return null;
			}
		}
	}
}