/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementClassification extends JavaScriptObject {

	protected JsICalendarElementClassification() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsICalendarElementClassification Public()
	/*-{
		return "Public";
	}-*/;

	public static final native JsICalendarElementClassification Private()
	/*-{
		return "Private";
	}-*/;

	public static final native JsICalendarElementClassification Confidential()
	/*-{
		return "Confidential";
	}-*/;

	public static final JsICalendarElementClassification create(net.bluemind.icalendar.api.ICalendarElement.Classification value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Public:
				return Public();
			case Private:
				return Private();
			case Confidential:
				return Confidential();
			default:
				return null;
			}
		}
	}
}