/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventCounterCounterOriginatorGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventCounter.CounterOriginator> {

	public VEventCounterCounterOriginatorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventCounter.CounterOriginator deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventCounter.CounterOriginator ret = new net.bluemind.calendar.api.VEventCounter.CounterOriginator();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventCounter.CounterOriginator ret, JSONObject json) {

		JSONValue commonNameJSON = json.get("commonName");
		ret.commonName =  GwtSerDerUtils.STRING.deserialize(commonNameJSON);
		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventCounter.CounterOriginator o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventCounter.CounterOriginator o, JSONObject ret) {

		ret.put("commonName",  GwtSerDerUtils.STRING.serialize( o.commonName ));
		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
	}
}