/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.calendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsPrintOptionsPrintFormat extends JavaScriptObject {

	protected JsPrintOptionsPrintFormat() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsPrintOptionsPrintFormat SVG()
	/*-{
		return "SVG";
	}-*/;

	public static final native JsPrintOptionsPrintFormat PDF()
	/*-{
		return "PDF";
	}-*/;

	public static final native JsPrintOptionsPrintFormat PNG()
	/*-{
		return "PNG";
	}-*/;

	public static final native JsPrintOptionsPrintFormat JPEG()
	/*-{
		return "JPEG";
	}-*/;

	public static final JsPrintOptionsPrintFormat create(net.bluemind.calendar.api.PrintOptions.PrintFormat value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case SVG:
				return SVG();
			case PDF:
				return PDF();
			case PNG:
				return PNG();
			case JPEG:
				return JPEG();
			default:
				return null;
			}
		}
	}
}