/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class PublishCalendarSockJsEndpoint implements net.bluemind.calendar.api.IPublishCalendarAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public PublishCalendarSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendars/publish/{containerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{containerUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public PublishCalendarSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void generateUrl(net.bluemind.calendar.api.PublishMode mode, final AsyncHandler<String> handler) {
		String postUri = "/_generate/{mode}";

		postUri = postUri.replace("{mode}", ""+mode);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void disableUrl(String url, final AsyncHandler<Void> handler) {
		String postUri = "/_disable";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( url);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getGeneratedUrls(net.bluemind.calendar.api.PublishMode mode, final AsyncHandler<List<String>> handler) {
		String postUri = "/generated/{mode}";

		postUri = postUri.replace("{mode}", ""+mode);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void publish(String token, final AsyncHandler<Stream> handler) {
		String postUri = "/{token}";

		postUri = postUri.replace("{token}", ""+token);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Stream>(handler) {
					@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void createUrl(net.bluemind.calendar.api.PublishMode mode, String token, final AsyncHandler<String> handler) {
		String postUri = "/_create/{mode}";

		postUri = postUri.replace("{mode}", ""+mode);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("token", ""+token);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.calendar.api.IPublishCalendarPromise promiseApi() {
		return new PublishCalendarEndpointPromise(this);
	}

}
