/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class CalendarAutocompleteSockJsEndpoint implements net.bluemind.calendar.api.ICalendarAutocompleteAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public CalendarAutocompleteSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendar/autocomplete";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public CalendarAutocompleteSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void calendarLookup(String pattern, net.bluemind.core.container.model.acl.Verb verb, final AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>> handler) {
		String postUri = "/_calendarLookup/{pattern}";

		postUri = postUri.replace("{pattern}", ""+pattern);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer().serialize( verb);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.calendar.api.CalendarLookupResponse>>(handler) {
					@Override
			protected List<net.bluemind.calendar.api.CalendarLookupResponse> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void calendarGroupLookup(String groupUid, final AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>> handler) {
		String postUri = "/_calendarsGroupLookup/{groupUid}";

		postUri = postUri.replace("{groupUid}", ""+groupUid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.calendar.api.CalendarLookupResponse>>(handler) {
					@Override
			protected List<net.bluemind.calendar.api.CalendarLookupResponse> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseGwtSerDer()).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.calendar.api.ICalendarAutocompletePromise promiseApi() {
		return new CalendarAutocompleteEndpointPromise(this);
	}

}
