<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilterRule.
 */
class MailFilterRule  {

  /*
   * @type String
   */
  public $name;

  /*
   * @type String
   */
  public $criteria;

  /*
   * @type boolean
   */
  public $star;

  /*
   * @type boolean
   */
  public $read;

  /*
   * @type boolean
   */
  public $delete;

  /*
   * @type boolean
   */
  public $discard;

  /*
   * @type MailFilterForwarding
   */
  public $forward;

  /*
   * @type String
   */
  public $deliver;

  /*
   * @type boolean
   */
  public $active;

  /*
   * @type boolean
   */
  public $stop;

  /*
   * Constructor
   */
  public function __construct() {
    $this->name = "";
    $this->criteria = "";
    $this->star = false;
    $this->read = false;
    $this->delete = false;
    $this->discard = false;
    $this->forward =   new MailFilterForwarding();
    $this->deliver = "";
    $this->active = false;
    $this->stop = false;
  }

  public function toMap() {
    $data = array(    
        "name" => empty($this->name) ? null : $this->name,    
        "criteria" => empty($this->criteria) ? null : $this->criteria,    
        "star" => empty($this->star) ? null : $this->star,    
        "read" => empty($this->read) ? null : $this->read,    
        "delete" => empty($this->delete) ? null : $this->delete,    
        "discard" => empty($this->discard) ? null : $this->discard,    
        "forward" => empty($this->forward) ? null : $this->forward,    
        "deliver" => empty($this->deliver) ? null : $this->deliver,    
        "active" => empty($this->active) ? null : $this->active,    
        "stop" => empty($this->stop) ? null : $this->stop);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
