/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VersionInfoGwtSerDer implements GwtSerDer<net.bluemind.core.api.VersionInfo> {

	public VersionInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.api.VersionInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.api.VersionInfo ret = new net.bluemind.core.api.VersionInfo();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.api.VersionInfo ret, JSONObject json) {

		JSONValue majorJSON = json.get("major");
		ret.major =  GwtSerDerUtils.STRING.deserialize(majorJSON);
		JSONValue minorJSON = json.get("minor");
		ret.minor =  GwtSerDerUtils.STRING.deserialize(minorJSON);
		JSONValue releaseJSON = json.get("release");
		ret.release =  GwtSerDerUtils.STRING.deserialize(releaseJSON);
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.api.VersionInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.api.VersionInfo o, JSONObject ret) {

		ret.put("major",  GwtSerDerUtils.STRING.serialize( o.major ));
		ret.put("minor",  GwtSerDerUtils.STRING.serialize( o.minor ));
		ret.put("release",  GwtSerDerUtils.STRING.serialize( o.release ));
		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
	}
}