<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Domain.
 */
class Domain  {

  /*
   * @type String
   */
  public $label;

  /*
   * @type String
   */
  public $name;

  /*
   * @type String
   */
  public $description;

  /*
   * @type Map
   */
  public $properties;

  /*
   * @type boolean
   */
  public $global;

  /*
   * @type Set
   */
  public $aliases;

  /*
   * @type String
   */
  public $defaultAlias;

  /*
   * Constructor
   */
  public function __construct() {
    $this->label = "";
    $this->name = "";
    $this->description = "";
    $this->properties = array();
    $this->global = false;
    $this->aliases = array();
    $this->defaultAlias = "";
  }

  public function toMap() {
    $data = array(    
        "label" => empty($this->label) ? null : $this->label,    
        "name" => empty($this->name) ? null : $this->name,    
        "description" => empty($this->description) ? null : $this->description,    
        "properties" => empty($this->properties) ? null : $this->properties,    
        "global" => empty($this->global) ? null : $this->global,    
        "aliases" => empty($this->aliases) ? null : $this->aliases,    
        "defaultAlias" => empty($this->defaultAlias) ? null : $this->defaultAlias);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
