/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.hot.upgrade.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class HotUpgradeTaskGwtSerDer implements GwtSerDer<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> {

	public HotUpgradeTaskGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.hot.upgrade.HotUpgradeTask deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.hot.upgrade.HotUpgradeTask ret = new net.bluemind.system.api.hot.upgrade.HotUpgradeTask();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeTask ret, JSONObject json) {

		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.INT.deserialize(idJSON);
		JSONValue operationJSON = json.get("operation");
		ret.operation =  GwtSerDerUtils.STRING.deserialize(operationJSON);
		JSONValue parametersJSON = json.get("parameters");
		ret.parameters =  GwtSerDerUtils.STRING.deserialize(parametersJSON);
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer().deserialize(statusJSON);
		JSONValue failureJSON = json.get("failure");
		ret.failure =  GwtSerDerUtils.INT.deserialize(failureJSON);
		JSONValue createdAtJSON = json.get("createdAt");
		ret.createdAt =  GwtSerDerUtils.DATE.deserialize(createdAtJSON);
		JSONValue updatedAtJSON = json.get("updatedAt");
		ret.updatedAt =  GwtSerDerUtils.DATE.deserialize(updatedAtJSON);
		JSONValue executionModeJSON = json.get("executionMode");
		ret.executionMode =  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer().deserialize(executionModeJSON);
		JSONValue retryCountJSON = json.get("retryCount");
		ret.retryCount =  GwtSerDerUtils.INT.deserialize(retryCountJSON);
		JSONValue retryDelaySecondsJSON = json.get("retryDelaySeconds");
		ret.retryDelaySeconds =  GwtSerDerUtils.INT.deserialize(retryDelaySecondsJSON);
		JSONValue reportFailureJSON = json.get("reportFailure");
		ret.reportFailure =  GwtSerDerUtils.BOOLEAN.deserialize(reportFailureJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.system.api.hot.upgrade.HotUpgradeTask o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeTask o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.INT.serialize( o.id ));
		ret.put("operation",  GwtSerDerUtils.STRING.serialize( o.operation ));
		ret.put("parameters",  GwtSerDerUtils.STRING.serialize( o.parameters ));
		ret.put("status",  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer().serialize( o.status ));
		ret.put("failure",  GwtSerDerUtils.INT.serialize( o.failure ));
		ret.put("createdAt",  GwtSerDerUtils.DATE.serialize( o.createdAt ));
		ret.put("updatedAt",  GwtSerDerUtils.DATE.serialize( o.updatedAt ));
		ret.put("executionMode",  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer().serialize( o.executionMode ));
		ret.put("retryCount",  GwtSerDerUtils.INT.serialize( o.retryCount ));
		ret.put("retryDelaySeconds",  GwtSerDerUtils.INT.serialize( o.retryDelaySeconds ));
		ret.put("reportFailure",  GwtSerDerUtils.BOOLEAN.serialize( o.reportFailure ));
	}
}