/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.hot.upgrade.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class InternalHotUpgradeGwtEndpoint implements net.bluemind.system.api.hot.upgrade.IInternalHotUpgradeAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public InternalHotUpgradeGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/hot_upgrade";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public InternalHotUpgradeGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void running(final AsyncHandler<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> handler) {
		String postUri = "/running";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>(handler) {
			@Override
			protected Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void progress(final AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>> handler) {
		String postUri = "/progress";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>>(handler) {
			@Override
			protected List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeProgressGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void list(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter filter, final AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> handler) {
		String postUri = "/list";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>(handler) {
			@Override
			protected List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void startLimited(long maxDuration, net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode mode, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/limitedStart";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&maxDuration=" + com.google.gwt.http.client.URL.encodeQueryString(""+maxDuration);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer().serialize( mode);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void count(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExcludeOperationFilter filter, final AsyncHandler<Long> handler) {
		String postUri = "/count";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExcludeOperationFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Long>(handler) {
			@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void start(boolean onlyReady, net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode mode, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/start";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&onlyReady=" + com.google.gwt.http.client.URL.encodeQueryString(""+onlyReady);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer().serialize( mode);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.system.api.hot.upgrade.IInternalHotUpgradePromise promiseApi() {
		return new InternalHotUpgradeEndpointPromise(this);
	}
}
