/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.hot.upgrade.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class HotUpgradeSockJsEndpoint implements net.bluemind.system.api.hot.upgrade.IHotUpgradeAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public HotUpgradeSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/hot_upgrade";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public HotUpgradeSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void running(final AsyncHandler<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> handler) {
		String postUri = "/running";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>(handler) {
					@Override
			protected Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void progress(final AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>> handler) {
		String postUri = "/progress";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>>(handler) {
					@Override
			protected List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeProgressGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void list(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter filter, final AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> handler) {
		String postUri = "/list";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>(handler) {
					@Override
			protected List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskGwtSerDer()).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.system.api.hot.upgrade.IHotUpgradePromise promiseApi() {
		return new HotUpgradeEndpointPromise(this);
	}

}
