/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SubscriptionInformationsGwtSerDer implements GwtSerDer<net.bluemind.system.api.SubscriptionInformations> {

	public SubscriptionInformationsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.SubscriptionInformations deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.SubscriptionInformations ret = new net.bluemind.system.api.SubscriptionInformations();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.SubscriptionInformations ret, JSONObject json) {

		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.STRING.deserialize(versionJSON);
		JSONValue installationVersionJSON = json.get("installationVersion");
		ret.installationVersion =  GwtSerDerUtils.STRING.deserialize(installationVersionJSON);
		JSONValue customerJSON = json.get("customer");
		ret.customer =  GwtSerDerUtils.STRING.deserialize(customerJSON);
		JSONValue customerCodeJSON = json.get("customerCode");
		ret.customerCode =  GwtSerDerUtils.STRING.deserialize(customerCodeJSON);
		JSONValue dealerJSON = json.get("dealer");
		ret.dealer =  GwtSerDerUtils.STRING.deserialize(dealerJSON);
		JSONValue distributorJSON = json.get("distributor");
		ret.distributor =  GwtSerDerUtils.STRING.deserialize(distributorJSON);
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsKindGwtSerDer().deserialize(kindJSON);
		JSONValue startsJSON = json.get("starts");
		ret.starts =  GwtSerDerUtils.DATE.deserialize(startsJSON);
		JSONValue endsJSON = json.get("ends");
		ret.ends =  GwtSerDerUtils.DATE.deserialize(endsJSON);
		JSONValue validJSON = json.get("valid");
		ret.valid =  GwtSerDerUtils.BOOLEAN.deserialize(validJSON);
		JSONValue pubKeyFingerprintJSON = json.get("pubKeyFingerprint");
		ret.pubKeyFingerprint =  GwtSerDerUtils.STRING.deserialize(pubKeyFingerprintJSON);
		JSONValue validProviderJSON = json.get("validProvider");
		ret.validProvider =  GwtSerDerUtils.BOOLEAN.deserialize(validProviderJSON);
		JSONValue fromTechVersionJSON = json.get("fromTechVersion");
		ret.fromTechVersion =  GwtSerDerUtils.STRING.deserialize(fromTechVersionJSON);
		JSONValue indicatorJSON = json.get("indicator");
		ret.indicator =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorGwtSerDer()).deserialize(indicatorJSON);
		JSONValue contactsJSON = json.get("contacts");
		ret.contacts =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(contactsJSON);
		JSONValue messagesJSON = json.get("messages");
		ret.messages =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsMessageGwtSerDer()).deserialize(messagesJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.system.api.SubscriptionInformations o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.SubscriptionInformations o, JSONObject ret) {

		ret.put("version",  GwtSerDerUtils.STRING.serialize( o.version ));
		ret.put("installationVersion",  GwtSerDerUtils.STRING.serialize( o.installationVersion ));
		ret.put("customer",  GwtSerDerUtils.STRING.serialize( o.customer ));
		ret.put("customerCode",  GwtSerDerUtils.STRING.serialize( o.customerCode ));
		ret.put("dealer",  GwtSerDerUtils.STRING.serialize( o.dealer ));
		ret.put("distributor",  GwtSerDerUtils.STRING.serialize( o.distributor ));
		ret.put("kind",  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsKindGwtSerDer().serialize( o.kind ));
		ret.put("starts",  GwtSerDerUtils.DATE.serialize( o.starts ));
		ret.put("ends",  GwtSerDerUtils.DATE.serialize( o.ends ));
		ret.put("valid",  GwtSerDerUtils.BOOLEAN.serialize( o.valid ));
		ret.put("pubKeyFingerprint",  GwtSerDerUtils.STRING.serialize( o.pubKeyFingerprint ));
		ret.put("validProvider",  GwtSerDerUtils.BOOLEAN.serialize( o.validProvider ));
		ret.put("fromTechVersion",  GwtSerDerUtils.STRING.serialize( o.fromTechVersion ));
		ret.put("indicator",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorGwtSerDer()).serialize( o.indicator ));
		ret.put("contacts",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.contacts ));
		ret.put("messages",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsMessageGwtSerDer()).serialize( o.messages ));
	}
}