/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DomainTemplateKindGwtSerDer implements GwtSerDer<net.bluemind.system.api.DomainTemplate.Kind> {

	public DomainTemplateKindGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.DomainTemplate.Kind deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.DomainTemplate.Kind ret = new net.bluemind.system.api.DomainTemplate.Kind();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.DomainTemplate.Kind ret, JSONObject json) {

		JSONValue descriptionJSON = json.get("description");
		ret.description =  new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionGwtSerDer().deserialize(descriptionJSON);
		JSONValue tagsJSON = json.get("tags");
		ret.tags =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.DomainTemplateTagGwtSerDer()).deserialize(tagsJSON);
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.system.api.DomainTemplate.Kind o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.DomainTemplate.Kind o, JSONObject ret) {

		ret.put("description",  new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionGwtSerDer().serialize( o.description ));
		ret.put("tags",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.DomainTemplateTagGwtSerDer()).serialize( o.tags ));
		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
	}
}