/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CustomLogoGwtSerDer implements GwtSerDer<net.bluemind.system.api.CustomLogo> {

	public CustomLogoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.CustomLogo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.CustomLogo ret = new net.bluemind.system.api.CustomLogo();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.CustomLogo ret, JSONObject json) {

		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.STRING.deserialize(versionJSON);
		JSONValue contentJSON = json.get("content");
		ret.content =  new GwtSerDerUtils.ByteArraySerDer().deserialize(contentJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.system.api.CustomLogo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.CustomLogo o, JSONObject ret) {

		ret.put("version",  GwtSerDerUtils.STRING.serialize( o.version ));
		ret.put("content",  new GwtSerDerUtils.ByteArraySerDer().serialize( o.content ));
	}
}