/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class InstallationEndpointPromise implements net.bluemind.system.api.IInstallationPromise {

	private net.bluemind.system.api.IInstallationAsync impl;

	public InstallationEndpointPromise(net.bluemind.system.api.IInstallationAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> setLogo(byte[] logo  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setLogo(logo,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.CustomLogo> getLogo() {
		
		CompletableFuture<net.bluemind.system.api.CustomLogo> ret = new CompletableFuture<net.bluemind.system.api.CustomLogo>();
		AsyncHandler<net.bluemind.system.api.CustomLogo> handler = new AsyncHandler<net.bluemind.system.api.CustomLogo>() {
			public void success(net.bluemind.system.api.CustomLogo value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getLogo( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteLogo() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteLogo( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.SystemState> getSystemState() {
		
		CompletableFuture<net.bluemind.system.api.SystemState> ret = new CompletableFuture<net.bluemind.system.api.SystemState>();
		AsyncHandler<net.bluemind.system.api.SystemState> handler = new AsyncHandler<net.bluemind.system.api.SystemState>() {
			public void success(net.bluemind.system.api.SystemState value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getSystemState( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> ping(String ip  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.ping(ip,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> removeSubscription() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.removeSubscription( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> runningMode() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.runningMode( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setSubscriptionContacts(List<String> emails  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setSubscriptionContacts(emails,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> getSubscriptionContacts() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getSubscriptionContacts( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> markSchemaAsUpgraded() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.markSchemaAsUpgraded( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> postinst() {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.postinst( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.UpgradeStatus> upgradeStatus() {
		
		CompletableFuture<net.bluemind.system.api.UpgradeStatus> ret = new CompletableFuture<net.bluemind.system.api.UpgradeStatus>();
		AsyncHandler<net.bluemind.system.api.UpgradeStatus> handler = new AsyncHandler<net.bluemind.system.api.UpgradeStatus>() {
			public void success(net.bluemind.system.api.UpgradeStatus value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.upgradeStatus( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.SubscriptionInformations.Kind> getSubscriptionKind() {
		
		CompletableFuture<net.bluemind.system.api.SubscriptionInformations.Kind> ret = new CompletableFuture<net.bluemind.system.api.SubscriptionInformations.Kind>();
		AsyncHandler<net.bluemind.system.api.SubscriptionInformations.Kind> handler = new AsyncHandler<net.bluemind.system.api.SubscriptionInformations.Kind>() {
			public void success(net.bluemind.system.api.SubscriptionInformations.Kind value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getSubscriptionKind( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.PublicInfos> getInfos() {
		
		CompletableFuture<net.bluemind.system.api.PublicInfos> ret = new CompletableFuture<net.bluemind.system.api.PublicInfos>();
		AsyncHandler<net.bluemind.system.api.PublicInfos> handler = new AsyncHandler<net.bluemind.system.api.PublicInfos>() {
			public void success(net.bluemind.system.api.PublicInfos value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getInfos( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> resetIndex(String index  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.resetIndex(index,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> resetIndexes() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.resetIndexes( handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> sendHostReport() {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sendHostReport( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Boolean> isValidProductionSubscription() {
		
		CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
		AsyncHandler<Boolean> handler = new AsyncHandler<Boolean>() {
			public void success(Boolean value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.isValidProductionSubscription( handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> getHostReport() {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getHostReport( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.InstallationVersion> getVersion() {
		
		CompletableFuture<net.bluemind.system.api.InstallationVersion> ret = new CompletableFuture<net.bluemind.system.api.InstallationVersion>();
		AsyncHandler<net.bluemind.system.api.InstallationVersion> handler = new AsyncHandler<net.bluemind.system.api.InstallationVersion>() {
			public void success(net.bluemind.system.api.InstallationVersion value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> upgrade() {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.upgrade( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> demoteLeader() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.demoteLeader( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateSubscription(String licence  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateSubscription(licence,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateSubscriptionVersion(String version  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateSubscriptionVersion(version,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateSubscriptionWithArchive(Stream archive  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateSubscriptionWithArchive(archive,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> clone(net.bluemind.system.api.CloneConfiguration sourceParams  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.clone(sourceParams,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.SubscriptionInformations> getSubscriptionInformations() {
		
		CompletableFuture<net.bluemind.system.api.SubscriptionInformations> ret = new CompletableFuture<net.bluemind.system.api.SubscriptionInformations>();
		AsyncHandler<net.bluemind.system.api.SubscriptionInformations> handler = new AsyncHandler<net.bluemind.system.api.SubscriptionInformations>() {
			public void success(net.bluemind.system.api.SubscriptionInformations value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getSubscriptionInformations( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> initialize() {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.initialize( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> maintenanceMode() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.maintenanceMode( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> promoteLeader() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.promoteLeader( handler);
		return ret;
	}

}
