/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailActionDescriptorGwtSerDer implements GwtSerDer<net.bluemind.mailflow.api.MailActionDescriptor> {

	public MailActionDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.api.MailActionDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.api.MailActionDescriptor ret = new net.bluemind.mailflow.api.MailActionDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.api.MailActionDescriptor ret, JSONObject json) {

		JSONValue actionIdentifierJSON = json.get("actionIdentifier");
		ret.actionIdentifier =  GwtSerDerUtils.STRING.deserialize(actionIdentifierJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue actionContextJSON = json.get("actionContext");
		ret.actionContext =  GwtSerDerUtils.STRING.deserialize(actionContextJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailflow.api.MailActionDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.api.MailActionDescriptor o, JSONObject ret) {

		ret.put("actionIdentifier",  GwtSerDerUtils.STRING.serialize( o.actionIdentifier ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("actionContext",  GwtSerDerUtils.STRING.serialize( o.actionContext ));
	}
}