package net.bluemind.core.backup.continuous.restore.domains.replication;

import com.fasterxml.jackson.core.type.TypeReference;

import net.bluemind.backend.mail.replica.api.IMailReplicaUids;
import net.bluemind.backend.mail.replica.api.MailboxReplica;
import net.bluemind.core.backup.continuous.RecordKey;
import net.bluemind.core.backup.continuous.RecordKey.Operation;
import net.bluemind.core.backup.continuous.restore.domains.RestoreDomainType;
import net.bluemind.core.backup.continuous.restore.domains.RestoreLogger;
import net.bluemind.core.backup.continuous.restore.domains.RestoreState;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.domain.api.Domain;

public class RestoreReplicatedMailboxes implements RestoreDomainType {

	private static final ValueReader<ItemValue<MailboxReplica>> mrReader = JsonUtils
			.reader(new TypeReference<ItemValue<MailboxReplica>>() {
			});

	private final RestoreLogger log;
	private final ItemValue<Domain> domain;
	private final RestoreState state;

	public RestoreReplicatedMailboxes(RestoreLogger log, ItemValue<Domain> domain, RestoreState state) {
		this.log = log;
		this.domain = domain;
		this.state = state;
	}

	@Override
	public String type() {
		return IMailReplicaUids.REPLICATED_MBOXES;
	}

	@Override
	public void restore(RecordKey key, String payload) {
		if (Operation.isDelete(key)) {
			log.filter(type(), key);
			return;
		}

	}
}
