package net.bluemind.core.backup.continuous.restore.domains.replication;

import java.util.stream.Collectors;

import com.fasterxml.jackson.core.type.TypeReference;

import net.bluemind.backend.mail.replica.api.IMailReplicaUids;
import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.core.backup.continuous.RecordKey;
import net.bluemind.core.backup.continuous.restore.domains.RestoreDomainType;
import net.bluemind.core.backup.continuous.restore.domains.RestoreLogger;
import net.bluemind.core.backup.continuous.restore.domains.RestoreState;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.sds.store.ISdsSyncStore;

public class RestoreMailboxRecords implements RestoreDomainType {

	private final ValueReader<ItemValue<MailboxRecord>> recReader = JsonUtils
			.reader(new TypeReference<ItemValue<MailboxRecord>>() {
			});

	private final RestoreLogger log;
	private final ISdsSyncStore sdsStore;
	private final RestoreState state;

	public RestoreMailboxRecords(RestoreLogger log, ISdsSyncStore sdsStore, RestoreState state) {
		this.log = log;
		this.sdsStore = sdsStore;
		this.state = state;
	}

	@Override
	public String type() {
		return IMailReplicaUids.MAILBOX_RECORDS;
	}

	@Override
	public void restore(RecordKey key, String payload) {

	}

	private String flags(ItemValue<MailboxRecord> rec) {
		return rec.value.flags.stream().map(itf -> itf.flag).collect(Collectors.joining(" "));
	}

}
