<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * JobExecution.
 */
class JobExecution  {

  /*
   * @type javautilDate
   */
  public $startDate;

  /*
   * @type javautilDate
   */
  public $endDate;

  /*
   * @type String
   */
  public $domainUid;

  /*
   * @type JobExitStatus
   */
  public $status;

  /*
   * @type String
   */
  public $jobId;

  /*
   * @type String
   */
  public $execGroup;

  /*
   * @type int
   */
  public $id;

  /*
   * Constructor
   */
  public function __construct() {
    $this->startDate = null;
    $this->endDate = null;
    $this->domainUid = "";
    $this->jobId = "";
    $this->execGroup = "";
    $this->id = 0;
  }

  public function toMap() {
    $data = array(    
        "startDate" => empty($this->startDate) ? null : $this->startDate,    
        "endDate" => empty($this->endDate) ? null : $this->endDate,    
        "domainUid" => empty($this->domainUid) ? null : $this->domainUid,    
        "status" => empty($this->status) ? null : $this->status,    
        "jobId" => empty($this->jobId) ? null : $this->jobId,    
        "execGroup" => empty($this->execGroup) ? null : $this->execGroup,    
        "id" => empty($this->id) ? null : $this->id);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
