/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerSyncStatusGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerSyncStatus> {

	public ContainerSyncStatusGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerSyncStatus deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerSyncStatus ret = new net.bluemind.core.container.model.ContainerSyncStatus();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerSyncStatus ret, JSONObject json) {

		JSONValue syncTokensJSON = json.get("syncTokens");
		ret.syncTokens =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(syncTokensJSON);
		JSONValue nextSyncJSON = json.get("nextSync");
		ret.nextSync =  GwtSerDerUtils.LONG.deserialize(nextSyncJSON);
		JSONValue lastSyncJSON = json.get("lastSync");
		ret.lastSync =  GwtSerDerUtils.DATE.deserialize(lastSyncJSON);
		JSONValue syncStatusJSON = json.get("syncStatus");
		ret.syncStatus =  new net.bluemind.core.container.model.gwt.serder.ContainerSyncStatusStatusGwtSerDer().deserialize(syncStatusJSON);
		JSONValue syncStatusInfoJSON = json.get("syncStatusInfo");
		ret.syncStatusInfo =  GwtSerDerUtils.STRING.deserialize(syncStatusInfoJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerSyncStatus o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerSyncStatus o, JSONObject ret) {

		ret.put("syncTokens",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.syncTokens ));
		ret.put("nextSync",  GwtSerDerUtils.LONG.serialize( o.nextSync ));
		ret.put("lastSync",  GwtSerDerUtils.DATE.serialize( o.lastSync ));
		ret.put("syncStatus",  new net.bluemind.core.container.model.gwt.serder.ContainerSyncStatusStatusGwtSerDer().serialize( o.syncStatus ));
		ret.put("syncStatusInfo",  GwtSerDerUtils.STRING.serialize( o.syncStatusInfo ));
	}
}