/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerDescriptorGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerDescriptor> {

    private net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer parent = new  net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer(); 
	public ContainerDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerDescriptor ret = new net.bluemind.core.container.model.ContainerDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerDescriptor ret, JSONObject json) {
		parent.deserializeTo( ret, json);

		JSONValue writableJSON = json.get("writable");
		ret.writable =  GwtSerDerUtils.BOOLEAN.deserialize(writableJSON);
		JSONValue verbsJSON = json.get("verbs");
		ret.verbs =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).deserialize(verbsJSON);
		JSONValue offlineSyncJSON = json.get("offlineSync");
		ret.offlineSync =  GwtSerDerUtils.BOOLEAN.deserialize(offlineSyncJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerDescriptor o, JSONObject ret) {
		parent.serializeTo( o, ret);

		ret.put("writable",  GwtSerDerUtils.BOOLEAN.serialize( o.writable ));
		ret.put("verbs",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).serialize( o.verbs ));
		ret.put("offlineSync",  GwtSerDerUtils.BOOLEAN.serialize( o.offlineSync ));
	}
}