/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerSubscriptionGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.ContainerSubscription> {

	public ContainerSubscriptionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.ContainerSubscription deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.ContainerSubscription ret = new net.bluemind.core.container.api.ContainerSubscription();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerSubscription ret, JSONObject json) {

		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue offlineSyncJSON = json.get("offlineSync");
		ret.offlineSync =  GwtSerDerUtils.BOOLEAN.deserialize(offlineSyncJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.api.ContainerSubscription o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerSubscription o, JSONObject ret) {

		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("offlineSync",  GwtSerDerUtils.BOOLEAN.serialize( o.offlineSync ));
	}
}