/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class OwnerSubscriptionsEndpointPromise implements net.bluemind.core.container.api.IOwnerSubscriptionsPromise {

	private net.bluemind.core.container.api.IOwnerSubscriptionsAsync impl;

	public OwnerSubscriptionsEndpointPromise(net.bluemind.core.container.api.IOwnerSubscriptionsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Long> getVersion() {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(Long since ,  net.bluemind.core.container.model.ItemFlagFilter filter  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.filteredChangesetById(since, filter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(String uid ,  Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ItemChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ItemChangelog>() {
			public void success(net.bluemind.core.container.model.ItemChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.itemChangelog(uid, since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> changesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> containerChangelog(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangelog>() {
			public void success(net.bluemind.core.container.model.ContainerChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.containerChangelog(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<Long>> allIds(String filter ,  Long knownContainerVersion ,  Integer limit ,  Integer offset  ) {
		
		CompletableFuture<net.bluemind.core.api.ListResult<Long>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<Long>>();
		AsyncHandler<net.bluemind.core.api.ListResult<Long>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<Long>>() {
			public void success(net.bluemind.core.api.ListResult<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allIds(filter, knownContainerVersion, limit, offset,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> list() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> getMultipleById(List<Long> id  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMultipleById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> getMultiple(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMultiple(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>> fullChangesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.fullChangesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> getCompleteById(long id  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCompleteById(id,  handler);
		return ret;
	}

}
