/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.hook;

public final class CalendarHookAddress {

	public static final String BASE_ADDRESS = "bm.calendar.hook";

	public static final String EVENT_CREATED = BASE_ADDRESS + ".created";
	public static final String EVENT_UPDATED = BASE_ADDRESS + ".updated";
	public static final String EVENT_DELETED = BASE_ADDRESS + ".deleted";
	public static final String CHANGED = BASE_ADDRESS + ".changed";

	public static String getChangedEventAddress(String containerUid) {
		return BASE_ADDRESS + "." + containerUid + ".changed";
	}
}
