/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.resolver.AddressResolverGroup;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.client.Http2ConnectionProvider;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.TransportConfig;
import reactor.util.annotation.Nullable;

final class HttpConnectionProvider
implements ConnectionProvider {
    final ConnectionProvider http1ConnectionProvider;
    final Supplier<ConnectionProvider> h2ConnectionProviderSupplier;
    final AtomicReference<ConnectionProvider> h2ConnectionProvider = new AtomicReference();

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver connectionObserver, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        if (((HttpClientConfig)config)._protocols == 4) {
            return this.http1ConnectionProvider.acquire(config, connectionObserver, remoteAddress, resolverGroup);
        }
        if (this.h2ConnectionProviderSupplier != null) {
            return this.h2ConnectionProviderSupplier.get().acquire(config, connectionObserver, remoteAddress, resolverGroup);
        }
        return this.getOrCreate(this.http1ConnectionProvider).acquire(config, connectionObserver, remoteAddress, resolverGroup);
    }

    @Override
    public void disposeWhen(SocketAddress address) {
        this.http1ConnectionProvider.disposeWhen(address);
    }

    @Override
    public int maxConnections() {
        return this.http1ConnectionProvider.maxConnections();
    }

    @Override
    public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return this.http1ConnectionProvider.maxConnectionsPerHost();
    }

    HttpConnectionProvider(ConnectionProvider http1ConnectionProvider) {
        this(http1ConnectionProvider, null);
    }

    HttpConnectionProvider(ConnectionProvider http1ConnectionProvider, @Nullable Supplier<ConnectionProvider> h2ConnectionProviderSupplier) {
        this.http1ConnectionProvider = http1ConnectionProvider;
        this.h2ConnectionProviderSupplier = h2ConnectionProviderSupplier;
    }

    ConnectionProvider getOrCreate(ConnectionProvider http1ConnectionProvider) {
        ConnectionProvider provider = this.h2ConnectionProvider.get();
        if (provider == null) {
            this.h2ConnectionProvider.compareAndSet(null, new Http2ConnectionProvider(http1ConnectionProvider));
            provider = this.getOrCreate(http1ConnectionProvider);
        }
        return provider;
    }
}

