/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.Http2ConnectionProvider;
import reactor.netty.http.client.HttpClientOperations;

final class Http2StreamBridgeClientHandler
extends ChannelDuplexHandler {
    final ConnectionObserver observer;
    final ChannelOperations.OnSetup opsFactory;

    Http2StreamBridgeClientHandler(ConnectionObserver listener, ChannelOperations.OnSetup opsFactory) {
        this.observer = listener;
        this.opsFactory = opsFactory;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Http2ConnectionProvider.registerClose(ctx.channel());
        ctx.read();
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> ops;
        if (HttpClientOperations.log.isDebugEnabled()) {
            HttpClientOperations.log.debug(ReactorNetty.format(ctx.channel(), "New HTTP/2 stream"));
        }
        if ((ops = this.opsFactory.create(Connection.from(ctx.channel()), this.observer, null)) != null) {
            ops.bind();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write((Object)new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

