/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.ReactorNetty;
import reactor.util.Logger;
import reactor.util.Loggers;

public class ByteBufFlux
extends FluxOperator<ByteBuf, ByteBuf> {
    final ByteBufAllocator alloc;
    static final Function<Object, ByteBuf> bytebufExtractor = o -> {
        if (o instanceof ByteBuf) {
            return (ByteBuf)o;
        }
        if (o instanceof ByteBufHolder) {
            return ((ByteBufHolder)o).content();
        }
        if (o instanceof byte[]) {
            return Unpooled.wrappedBuffer((byte[])((byte[])o));
        }
        throw new IllegalArgumentException("Object " + o + " of type " + o.getClass() + " cannot be converted to ByteBuf");
    };
    static final int MAX_CHUNK_SIZE = 524288;
    static final Logger log = Loggers.getLogger(ByteBufFlux.class);

    public static ByteBufFlux fromInbound(Publisher<?> source2) {
        return ByteBufFlux.fromInbound(source2, ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromInbound(Publisher<?> source2, ByteBufAllocator allocator) {
        Objects.requireNonNull(allocator, "allocator");
        return ByteBufFlux.maybeFuse(Flux.from(ReactorNetty.publisherOrScalarMap(source2, bytebufExtractor)), allocator);
    }

    public static ByteBufFlux fromString(Publisher<? extends String> source2) {
        return ByteBufFlux.fromString(source2, Charset.defaultCharset(), ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromString(Publisher<? extends String> source2, Charset charset, ByteBufAllocator allocator) {
        Objects.requireNonNull(allocator, "allocator");
        Objects.requireNonNull(charset, "charset");
        return ByteBufFlux.maybeFuse(Flux.from(ReactorNetty.publisherOrScalarMap(source2, s2 -> {
            ByteBuf buffer = allocator.buffer();
            buffer.writeCharSequence((CharSequence)s2, charset);
            return buffer;
        })), allocator);
    }

    public static ByteBufFlux fromPath(Path path) {
        return ByteBufFlux.fromPath(path, 524288);
    }

    public static ByteBufFlux fromPath(Path path, int maxChunkSize) {
        return ByteBufFlux.fromPath(path, maxChunkSize, ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromPath(Path path, ByteBufAllocator allocator) {
        return ByteBufFlux.fromPath(path, 524288, allocator);
    }

    public static ByteBufFlux fromPath(Path path, int maxChunkSize, ByteBufAllocator allocator) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(allocator, "allocator");
        if (maxChunkSize < 1) {
            throw new IllegalArgumentException("chunk size must be strictly positive, was: " + maxChunkSize);
        }
        return ByteBufFlux.maybeFuse(Flux.generate(() -> FileChannel.open(path, new OpenOption[0]), (fc, sink2) -> {
            ByteBuf buf = allocator.buffer();
            try {
                if (buf.writeBytes((ScatteringByteChannel)fc, maxChunkSize) < 0) {
                    buf.release();
                    sink2.complete();
                } else {
                    sink2.next(buf);
                }
            }
            catch (IOException e) {
                buf.release();
                sink2.error(e);
            }
            return fc;
        }, ReactorNetty.fileCloser), allocator);
    }

    public final Flux<ByteBuffer> asByteBuffer() {
        return this.handle((bb, sink2) -> {
            try {
                sink2.next(bb.nioBuffer());
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public final Flux<byte[]> asByteArray() {
        return this.handle((bb, sink2) -> {
            try {
                byte[] bytes = new byte[bb.readableBytes()];
                bb.readBytes(bytes);
                sink2.next(bytes);
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public final Flux<InputStream> asInputStream() {
        return this.handle((bb, sink2) -> {
            try {
                sink2.next(new ByteBufMono.ReleasingInputStream((ByteBuf)bb));
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public final Flux<String> asString() {
        return this.asString(Charset.defaultCharset());
    }

    public final Flux<String> asString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return this.handle((bb, sink2) -> {
            try {
                sink2.next(bb.readCharSequence(bb.readableBytes(), charset).toString());
            }
            catch (IllegalReferenceCountException e) {
                sink2.complete();
            }
        });
    }

    public final ByteBufMono aggregate() {
        return Mono.defer(() -> {
            CompositeByteBuf output = this.alloc.compositeBuffer();
            return this.doOnNext(ByteBuf::retain).collectList().doOnDiscard(ByteBuf.class, ByteBufFlux::safeRelease).handle((list, sink2) -> {
                block5: {
                    if (!list.isEmpty()) {
                        try {
                            output.addComponents(true, (Iterable)list);
                        }
                        catch (IllegalReferenceCountException e) {
                            if (!log.isDebugEnabled()) break block5;
                            log.debug("", e);
                        }
                    }
                }
                if (output.isReadable()) {
                    sink2.next(output);
                } else {
                    sink2.complete();
                }
            }).doFinally(signalType -> ByteBufFlux.safeRelease((ByteBuf)output));
        }).as(ByteBufMono::maybeFuse);
    }

    public final ByteBufMono multicast() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public final ByteBufFlux retain() {
        return ByteBufFlux.maybeFuse(this.doOnNext(ByteBuf::retain), this.alloc);
    }

    ByteBufFlux(Flux<ByteBuf> source2, ByteBufAllocator allocator) {
        super(source2);
        this.alloc = allocator;
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuf> s2) {
        this.source.subscribe(s2);
    }

    static ByteBufFlux maybeFuse(Flux<ByteBuf> source2, ByteBufAllocator allocator) {
        if (source2 instanceof Fuseable) {
            return new ByteBufFluxFuseable(source2, allocator);
        }
        return new ByteBufFlux(source2, allocator);
    }

    static void safeRelease(ByteBuf byteBuf) {
        block3: {
            if (byteBuf.refCnt() > 0) {
                try {
                    byteBuf.release();
                }
                catch (IllegalReferenceCountException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("", e);
                }
            }
        }
    }

    static final class ByteBufFluxFuseable
    extends ByteBufFlux
    implements Fuseable {
        ByteBufFluxFuseable(Flux<ByteBuf> source2, ByteBufAllocator allocator) {
            super(source2, allocator);
        }
    }
}

