/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.tasks;

import com.google.common.io.ByteStreams;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IStatefulResponseHandler;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.tasks.IUploadSession;
import com.microsoft.graph.tasks.LargeFileUploadResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;

class LargeFileUploadResponseHandler<UploadType>
implements IStatefulResponseHandler<LargeFileUploadResponse<UploadType>, UploadType> {
    private final Class<UploadType> deserializeTypeClass;
    private final Class<? extends IUploadSession> uploadSessionClass;

    protected LargeFileUploadResponseHandler(@Nonnull Class<UploadType> uploadType, @Nonnull Class<? extends IUploadSession> uploadSessionType) {
        this.deserializeTypeClass = Objects.requireNonNull(uploadType, "parameter uploadType cannot be null");
        this.uploadSessionClass = Objects.requireNonNull(uploadSessionType, "parameter uploadSessionType cannot be null");
    }

    @Override
    @Nullable
    public <ResponseType> LargeFileUploadResponse<UploadType> generateResult(@Nonnull IHttpRequest request, @Nonnull ResponseType response, @Nonnull ISerializer serializer, @Nonnull ILogger logger) throws Exception {
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(response, "parameter response cannot be null");
        Objects.requireNonNull(serializer, "parameter serializer cannot be null");
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        if (!(response instanceof Response)) {
            throw new ClientException("unsupported response type", null);
        }
        Response nativeResponse = (Response)response;
        if (nativeResponse.code() >= 400) {
            logger.logDebug("Receiving error during upload, see detail on result error");
            return new LargeFileUploadResponse(GraphServiceException.createFromResponse(request, null, serializer, nativeResponse, logger));
        }
        if (nativeResponse.code() >= 200 && nativeResponse.code() < 300) {
            try (ResponseBody body = nativeResponse.body();){
                String subType;
                String location = nativeResponse.headers().get("Location");
                MediaType contentType = body.contentType();
                String string = subType = contentType == null ? null : contentType.subtype();
                if (subType != null && subType.contains("json")) {
                    LargeFileUploadResponse<UploadType> largeFileUploadResponse = this.parseJsonUploadResult(body, serializer, logger);
                    return largeFileUploadResponse;
                }
                if (location != null) {
                    logger.logDebug("Upload session is completed (Outlook), uploaded item returned.");
                    LargeFileUploadResponse largeFileUploadResponse = new LargeFileUploadResponse(location);
                    return largeFileUploadResponse;
                }
                logger.logDebug("Upload session returned an unexpected response");
            }
        }
        return new LargeFileUploadResponse(new ClientException("Received an unexpected response from the service, response code: " + nativeResponse.code(), null));
    }

    @Nonnull
    private LargeFileUploadResponse<UploadType> parseJsonUploadResult(@Nonnull ResponseBody responseBody, @Nonnull ISerializer serializer, @Nonnull ILogger logger) throws IOException {
        try (InputStream in = responseBody.byteStream();){
            byte[] responseBytes = ByteStreams.toByteArray(in);
            IUploadSession session = serializer.deserializeObject(new ByteArrayInputStream(responseBytes), this.uploadSessionClass);
            if (session == null || session.getNextExpectedRanges() == null) {
                logger.logDebug("Upload session is completed (ODSP), uploaded item returned.");
                UploadType uploadedItem = serializer.deserializeObject(new ByteArrayInputStream(responseBytes), this.deserializeTypeClass);
                LargeFileUploadResponse<UploadType> largeFileUploadResponse = new LargeFileUploadResponse<UploadType>(uploadedItem);
                return largeFileUploadResponse;
            }
            logger.logDebug("Chunk bytes has been accepted by the server.");
            LargeFileUploadResponse largeFileUploadResponse = new LargeFileUploadResponse(session);
            return largeFileUploadResponse;
        }
    }
}

